/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.teastory.fluid;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import xueluoanping.teastory.registry.FluidRegistry;

public class TeaFluidType
extends FluidType {
    private final ResourceLocation STILL_TEXTURE;
    private final ResourceLocation FLOWING_TEXTURE;
    private int colourTint;

    public TeaFluidType(FluidType.Properties properties) {
        this(properties, FluidRegistry.WATER_STILL_TEXTURE, FluidRegistry.WATER_FLOW_TEXTURE);
    }

    public TeaFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
        super(properties);
        this.STILL_TEXTURE = stillTexture;
        this.FLOWING_TEXTURE = flowingTexture;
    }

    public TeaFluidType color(int colourTint) {
        this.colourTint = colourTint;
        return this;
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return TeaFluidType.this.STILL_TEXTURE;
            }

            public ResourceLocation getFlowingTexture() {
                return TeaFluidType.this.FLOWING_TEXTURE;
            }

            public int getTintColor() {
                return TeaFluidType.this.colourTint;
            }

            @NotNull
            public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                int color = this.getTintColor();
                float Red = (float)((double)(color >> 16 & 0xFF) / 255.0);
                float Green = (float)((double)(color >> 8 & 0xFF) / 255.0);
                float Blue = (float)((double)(color & 0xFF) / 255.0);
                return new Vector3f(Red, Green, Blue);
            }

            public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                int color = this.getTintColor();
                float alpha = (float)((double)(color >> 24 & 0xFF) / 255.0);
                RenderSystem.setShaderFogStart((float)0.125f);
                RenderSystem.setShaderFogEnd((float)(2.0f + 3.0f * (1.0f - alpha)));
            }
        });
    }
}

